IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CPJ_Estado_de_Resultados') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [CPJ_Estado_de_Resultados]
END
GO

CREATE PROCEDURE [dbo].[CPJ_Estado_de_Resultados] @pJsonRecibido VARCHAR(8000)
AS 
SET NOCOUNT ON
/*Parametros*/

DECLARE 	@pFechaDesde			DATETIME,
			@pFechaHasta			DATETIME,
			@pId_Unid_Negocio       VARCHAR(10),
			@pFiltrar_solo_Asientos TINYINT,
			@pId_Centro_Costo       CHAR(10),
			@pId_Plan_Cta           SMALLINT


	SET @pId_Unid_Negocio			= ISNULL(CONVERT(VARCHAR(10), dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Unid_Negocio')),'')
	SET @pFechaDesde				= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'FechaDesde')),GETDATE())
	SET @pFechaHasta				= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'FechaHasta')),GETDATE())
	SET @pFiltrar_solo_asientos	    = ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Filtrar_solo_Asientos')),0)
	SET @pId_Centro_Costo			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Centro_Costo')),0)
	SET @pId_Plan_Cta			    = ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Plan_Cta')),0)


    SELECT ID_UNID_NEGOCIO INTO #UN FROM Empresas_Unid_Negocios

    IF CAST(@pId_Unid_Negocio as int) <> 0
       DELETE #UN WHERE ID_UNID_NEGOCIO <> @pId_Unid_Negocio 

    SELECT Id_Centro_Costo INTO #CCostos FROM Centro_Costos 
	 
    IF CAST(@pId_Centro_Costo as int) <> 0
       DELETE #Ccostos  WHERE Id_Centro_Costo <> @pId_Centro_Costo 

SELECT C.Alias,C.Nro_Cta_Contable,C.Descripcion as Descripcion_Cta,I.Id_Centro_Costo,CC.Descripcion as Descripcion_CC,C.Id_Clasificacion,CL.Descripcion as Descripcion_CL,C.Id_Subclasificacion,SC.Descripcion as Descripcion_SC,SUM(I.Debe) as Debe,SUM(I.Haber) as Haber
       into #Resultado
               FROM Asientos_Items I, Asientos A, Pla_Ctas_Cuentas_Contables C, Plan_Ctas_Clasificaciones CL,Plan_Ctas_Subclasificaciones SC,Centro_Costos CC,#UN U, #Ccostos K
               WHERE A.Id_Asiento = I.Id_Asiento 
			   AND A.Id_Unid_Negocio = U.Id_Unid_Negocio
			   AND K.Id_Centro_Costo = I.Id_Centro_Costo
               And I.Id_Cta_Contable = C.Id_Cta_Contable 
               AND ISNULL(C.Id_Clasificacion,0) <> 0 
			   AND C.Id_Clasificacion = CL.Id_Clasificacion
			   AND C.Id_Subclasificacion = SC.Id_Subclasificacion
			   AND CC.Id_Centro_Costo = ISNULL(I.Id_Centro_Costo,'')
               AND A.Balanceado = 1
               AND A.Id_Plan_Cta = @pId_Plan_Cta
	           AND A.FECHA >= @pFechaDesde 
		       AND A.FECHA < dateadd(dd,1,@pFechaHasta)
      GROUP BY C.Alias,C.Nro_Cta_Contable,C.Descripcion,I.Id_Centro_Costo,CC.Descripcion,C.Id_Clasificacion,CL.Descripcion,C.Id_Subclasificacion,SC.Descripcion
 
If @pFiltrar_solo_asientos = 0
   BEGIN

		SELECT I.Alias,C.Nro_Cta_Contable,C.Descripcion as Descripcion_Cta,I.Id_Centro_Costo,CC.Descripcion as Descripcion_CC,C.Id_Clasificacion,CL.Descripcion as Descripcion_CL,C.Id_Subclasificacion,SC.Descripcion as Descripcion_SC,SUM(I.Debe) as Debe,SUM(I.Haber) as Haber
				 INTO #COMPROBANTES
					   FROM Cbtes_Ctas_Contables I, Cbtes A, Pla_Ctas_Cuentas_Contables C, Plan_Ctas_Clasificaciones CL,Plan_Ctas_Subclasificaciones SC,Centro_Costos CC, Cbtes_Tipos T,#UN U, #Ccostos K
						  WHERE A.Id_Trans = I.Id_Trans 
						  AND T.Id_Unid_Negocio = U.Id_Unid_Negocio
						  AND K.Id_Centro_Costo = I.Id_Centro_Costo
						  And I.Id_Cta_Contable = C.Id_Cta_Contable 
						  AND C.Id_Clasificacion <> 0 
						  AND C.Id_Clasificacion = CL.Id_Clasificacion
						  AND C.Id_Subclasificacion = SC.Id_Subclasificacion
						  AND C.Id_Plan_Cta = @pId_Plan_Cta
						  AND CC.Id_Centro_Costo = ISNULL(I.Id_Centro_Costo,'')
  						  AND (I.Id_Asiento = 0 OR I.Id_Asiento IS NULL)
						  AND A.Id_Tipo_Cbte = T.Id_Tipo_Cbte 
						  AND T.Compromete_Asientos <> 0
						  AND A.Id_Estado_Cbte NOT IN (0,3)
						  AND A.Periodo_Iva >= @pFechaDesde 
						  AND A.Periodo_Iva < dateadd(dd,1,@pFechaHasta)
				 GROUP BY I.Alias,C.Nro_Cta_Contable,C.Descripcion,I.Id_Centro_Costo,CC.Descripcion,C.Id_Clasificacion,CL.Descripcion,C.Id_Subclasificacion,SC.Descripcion


		UPDATE #Resultado SET DEBE = R.DEBE + C.DEBE, HABER = R.HABER + C.HABER FROM #Resultado R, #COMPROBANTES C
			   WHERE R.Alias = C.Alias AND  R.Id_Centro_Costo = C.Id_Centro_Costo
 
		INSERT INTO #Resultado 
			   SELECT * FROM #COMPROBANTES C
					  WHERE  NOT EXISTS (SELECT R.Alias FROM #Resultado R 
										 WHERE R.Alias = C.Alias AND R.Id_Centro_Costo = C.Id_Centro_Costo)
        DROP TABLE #COMPROBANTES
   END


ALTER TABLE #Resultado ADD Total_Clasif Decimal(16,2), Total_SClasif Decimal(16,2) 


SELECT Id_Clasificacion,SUM(HABER-DEBE) AS TOTAL_CLASIF INTO #TOT_CLASIF FROM #Resultado GROUP BY Id_Clasificacion

SELECT Id_Clasificacion,Id_Subclasificacion,SUM(HABER-DEBE) AS Total_SClasif INTO #TOT_SUBCLASIF FROM #Resultado GROUP BY Id_Clasificacion,Id_Subclasificacion


UPDATE #Resultado SET Total_Clasif = T.TOTAL_CLASIF 
FROM #Resultado R, #TOT_CLASIF T WHERE T.Id_Clasificacion = R.Id_Clasificacion

UPDATE #Resultado SET Total_SClasif = T.Total_SClasif 
FROM #Resultado R, #TOT_SUBCLASIF T WHERE T.Id_Clasificacion = R.Id_Clasificacion AND R.Id_Subclasificacion = T.Id_Subclasificacion


SELECT * FROM #Resultado Order By Id_Clasificacion,Id_Subclasificacion,Nro_Cta_Contable

DROP TABLE #Resultado
DROP TABLE #TOT_SUBCLASIF
DROP TABLE #TOT_CLASIF
DROP TABLE #UN
DROP TABLE #CCostos

/*
 EXEC [CPJ_Estado_de_Resultados] '{"FechaDesde":"20170101","FechaHasta":"20210929","Id_Unid_Negocio":" ","Filtrar_solo_Asientos":"1","Id_Centro_Costo":" "}'


EXEC CPJ_Estado_de_Resultados '{"FechaDesde":"20210101","FechaHasta":"20211012","Id_Unid_Negocio":"","Filtrar_solo_Asientos":"","Id_Centro_Costo":"","Id_Plan_Cta":"3"}'

*/